% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.tvcure.R
\name{print.tvcure}
\alias{print.tvcure}
\title{Print summary information on a \code{tvcure.object}.}
\usage{
\method{print}{tvcure}(x, ci.level=.95,expEst=TRUE,
             digits.est=3,digits.edf=2,digits.tst=2,digits.Pvalue=3,...)
}
\arguments{
\item{x}{an object of class \code{\link{tvcure.object}}.}

\item{ci.level}{(optional) nominal level for the plotted pointwise credible intervals (default: .95).}

\item{expEst}{(optional) logical indicating if the exponential of the regression parameter estimates should also be provided (with their confidence interval) (default: TRUE).}

\item{digits.est}{number of digits when reporting parameter estimates (default: 3).}

\item{digits.edf}{number of digits when reporting effective degrees of freedom (default: 2).}

\item{digits.tst}{number of digits when reporting test statistics (default: 2).}

\item{digits.Pvalue}{number of digits when reporting P-values (default: 3).}

\item{...}{additional generic printing arguments.}
}
\value{
No returned value (just printed summary).
}
\description{
Print summary information on a \code{tvcure.object} generated by \code{\link{tvcure}}.
}
\details{
Provides summary measures on the estimation of the regression parameters and additive terms
in the tvcure model corresponding to a \code{\link{tvcure.object}} generated by \code{\link{tvcure}}.
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)
print(model)
}

}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\seealso{
\code{\link{tvcure}}, \code{\link{tvcure.object}}, \code{\link{plot.tvcure}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
