% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvcure.R
\name{tvcure}
\alias{tvcure}
\title{Fit of a tvcure model.}
\usage{
tvcure(formula1, formula2, data,
       model0=NULL, noestimation=FALSE,
       baseline=c("S0","F0"), K0=20, pen.order0=2,
       K1=10, pen.order1=2, K2=10, pen.order2=2,
       phi.0=NULL, beta.0=NULL, gamma.0=NULL,
       a.tau=1, b.tau=1e-6, a.pen=1, b.pen=1e-4,
       tau.0=NULL, tau.min=1, tau.method = c("LPS","LPS2","Schall","grid","none"),
       psi.method = c("LM","NR","none"),
       lambda1.0=NULL, lambda1.min=1, lambda2.0=NULL, lambda2.min=1,
       lambda.method=c("LPS","LPS2","LPS3","nlminb","none"),
       logscale=FALSE,
       observed.hessian=TRUE, use.Rfast=TRUE, Wood.test=FALSE,
       ci.level=.95,
       criterion=c("logEvid","deviance","lpen","AIC","BIC","gradient"),
       criterion.tol=1e-2, grad.tol=1e-2,
       RDM.tol=1e-4, fun.tol=1e-3, Lnorm=c("Linf","L2"),
       iterlim=50, iter.verbose=FALSE, verbose=FALSE)
}
\arguments{
\item{formula1}{A formula describing the linear predictor in the long-term (cure) survival (or quantum) submodel.}

\item{formula2}{A formula describing the linear predictor in the short-term (cure) survival (or timing) submodel.}

\item{data}{A data frame with survival data in a counting process format. It should always contain at least the following entries:
\itemize{
\item \code{id} : the <id> of the unit associated to the data in a given line in the data frame.
\item \code{time} : the integer time at which the observations are reported. For a given unit, it should be a sequence of CONSECUTIVE integers starting at 1 for the first observation.
\item \code{event} : a sequence of 0-1 event indicators. For the lines corresponding to a given unit, it starts with 0 values concluded by a 0 in case of right-censoring or by a 1 if the event is observed at the end of the follow-up.
}}

\item{model0}{(Optional) tvcure object from which starting values for the regression parameters, spline and penalty parameters are extracted. Make sure that it corresponds to the same model specification. The values of its components are overhidden by \code{phi.0}, \code{beta.0}, \code{gamma.0}, \code{tau.0}, \code{lambda1.0}, \code{lambda2.0} when they are not NULL. That possibility can be found useful to accelerate the fit of the same model on other data or for specific changes in model parameters (such as penalty parameters). (Default: NULL).}

\item{noestimation}{Logical specifying that regression, spline and penalty parameters should not be estimated, but rather be fixed at their initial values (as for example provided by \code{model0} or other entries). (Default: FALSE).}

\item{baseline}{Baseline ("S0" or "F0") used to specify the dependence of the cumulative hazard dynamics on covariates (Default: "S0"):
Baseline S0: \eqn{S(t|x) = S_0(t)^{\exp^{\gamma'x}}} ;  Baseline F0: \eqn{F(t|x) = F_0(t)^{\exp{\gamma'x}}}}

\item{K0}{Number of B-splines used to specify \eqn{\log f_0(t)} (Default: 20).}

\item{pen.order0}{Penalty order for the P-splines used to specify \eqn{\log f_0(t)} (Default: 2).}

\item{K1}{Number of P-splines for a given additive term in the long-term (or quantum) survival sumbodel (Default: 10).}

\item{pen.order1}{Penalty order for the P-splines in the long-term survival (or quantum) sumbodel (Default: 2).}

\item{K2}{Number of P-splines for a given additive term in the short-term (or timing) survival sumbodel (Default: 10).}

\item{pen.order2}{Penalty order for the P-splines in the short-term survival (or timing) sumbodel (Default: 2).}

\item{phi.0}{(Optional) vector of length \code{K0} with starting values for the P-spline parameters in \eqn{\log f_0(t)}.}

\item{beta.0}{(Optional) starting value for the regression and spline parameters in the long-term survival (or quantum) submodel.}

\item{gamma.0}{(Optional) starting value for the regression and spline parameters in the short-term survival (or timing) submodel.}

\item{a.tau}{Hyperprior parameter in the Gamma(a.tau,b.tau) prior for the penalty parameter \eqn{\tau} tuning the smoothness of \eqn{\log f_0(t)} (Default: 1.0).}

\item{b.tau}{Hyperprior parameter in the Gamma(a.tau,b.tau) prior for the penalty parameter \eqn{\tau} tuning the smoothness of \eqn{\log f_0(t)} (Default: 1e-6).}

\item{a.pen}{Hyperprior parameter in the Gamma(a.pen,b.pen) priors for the penalty parameters \eqn{\lambda_1} and \eqn{\lambda_2} tuning the smoothness of the additive terms in the long-term (quantum) and short-term (timing) survival submodels. (Default: 1.0).}

\item{b.pen}{Hyperprior parameter in the Gamma(a.pen,b.pen) priors for the penalty parameters \eqn{\lambda_1} and \eqn{\lambda_2} tuning the smoothness of the additive terms in the long-term (quantum) and short-term (timing) survival submodels. (Default: 1e-4).}

\item{tau.0}{Starting value for \eqn{\tau}.}

\item{tau.min}{Minimal value for the penalty parameter \eqn{\tau}. (Default: 1.0).}

\item{tau.method}{Method used to calculate the posterior mode of \eqn{p(\tau|{\cal D})}: "LPS", "LPS2", "Schall" (Fellner-Schall algorithm), "grid" (best choice in a regular grid on the log-scale) or "none" (stick to the initial value tau.0). LPS and LPS2, based on Laplace P-splines, both maximize the marginal posterior of the penalty parameter \eqn{\tau} using a fixed-point method, with LPS relying on the prior calculation of eigenvalues. (Default: "LPS").}

\item{psi.method}{Algorithm used for the computation of the conditional posterior mode of the regression and splines parameters. Possible choices are Levenberg-Marquardt ("LM"), Newton-Raphson ("NR") or "none" (when the coefficients remain fixed at their initial values).}

\item{lambda1.0}{(Optional) J1-vector with starting values for the penalty parameters of the additive terms in the long-term survival (or quantum) submodel.}

\item{lambda1.min}{Minimal value for the J1 penalty parameters \eqn{\lambda_1} of the additive terms in the long-term survival (or quantum) submodel. (Default: 1.0).}

\item{lambda2.0}{(Optional) J2-vector with starting values for the penalty parameters of the additive terms in the short-term survival (or timing) submodel.}

\item{lambda2.min}{Minimal value for the J2 penalty parameters \eqn{\lambda_2} of the additive terms in the short-term survival (or timing) submodel. (Default: 1.0).}

\item{lambda.method}{Method used ("LPS", "LPS2", "LPS3", "nlminb" or "none") to select the penalty parameters of the additive terms in the long-term survival (or quantum) submodel:
\itemize{
\item \code{LPS}, \code{LPS2}, or \code{LPS3} : based on Laplace P-splines where the marginal posterior of the penalty parameters is maximized using a fixed-point method. LPS is based on the prior calculation of eigenvalues (unlike LPS2) and delivers results of comparable quality to those of nlminb, but much more quickly. LPS3 work sequentially and separately on long- and short-term parameters with potentially convergence issues ;
\item \code{Schall} : Fellner-Schall method ;
\item \code{nlminb} : nonlinear maximization of the marginal posterior of the penalty parameters using the R function <nlminb> ;
\item \code{none} : penalty parameters are set at their initial values. }}

\item{logscale}{Logical: when TRUE, select \eqn{\lambda_1} or \eqn{\lambda_2} by maximizing \eqn{p(\log(\lambda_k)|D)},  maximize \eqn{p(\lambda_k|D)} otherwise. (Default= FALSE).}

\item{observed.hessian}{Logical indicating if a fast approximation of the Hessian matrix based on cross-products is preferred over its expected value. (Default: TRUE).}

\item{use.Rfast}{Logical indicating if matrix functions from the Rfast package should be used to fasten computation. (Default: TRUE).}

\item{Wood.test}{Logical indicating if P-values based on Wood's test (Biometrika 2013) of the significance of additive terms should be preferred over basic Chi-square tests. (Default: FALSE).}

\item{ci.level}{Default value for the levels of the credible intervals. (Default: 0.95).}

\item{criterion}{Criterion used to assess convergence of the estimation procedure (Default: "logEvid"):
\itemize{
\item \code{logEvid} : log of the evidence (also named \emph{marginal likelihood} or \emph{model likelihood}), i.e. the log of the marginal posterior of the penalty parameters at their selected values ;
\item \code{deviance} : deviance or -2 log(Likelihood) ;
\item \code{AIC} : Akaike information criterion ;
\item \code{BIC} : Bayesian (or Schwarz) information criterion ;
\item \code{gradient} : Lp-norm of the gradient of the log of the joint posterior w.r.t. the regression and spline parameters.}}

\item{criterion.tol}{Maximum absolute difference between the successive values of the \code{criterion} values (when different from "gradient") to declare convergence. (Default: 1e-2).}

\item{grad.tol}{Tolerance threshold for the absolute value of each gradient component when monitoring convergence. (default: 1e-2).}

\item{RDM.tol}{Tolerance thershold for the Relative Damping Measure (= RDM) when monitoring convergence (default: 1e-4).}

\item{fun.tol}{Tolerance threshold for variations in the maximized function during the final iterations of posterior mode computation and convergence monitoring (default: 1e-3).}

\item{Lnorm}{Lp norm used to evaluate the gradient for convergence assessment. Options are "Linf" (default) or "L2".}

\item{iterlim}{Maximum number of iterations. (Default: 50).}

\item{iter.verbose}{Logical indicating if the values of the convergence criterions should be printed after each iteration. (Default: FALSE).}

\item{verbose}{Logical indicating if additional output based on gradients should be printed at the end of each iteration. (Default: FALSE).}
}
\value{
An object of type \code{\link{tvcure.object}}.
}
\description{
Fit of a double additive cure survival model with exogenous time-varying covariates.
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)
print(model)
plot(model, pages=1)
}

}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
