% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvYearPaidAnnuityCompYearly.R
\name{pvYearlyPaidAnnuityCompYearly}
\alias{pvYearlyPaidAnnuityCompYearly}
\title{Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Annually.}
\usage{
pvYearlyPaidAnnuityCompYearly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}
}
\description{
Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Annually.
}
\details{
Classification of annuities is done by \insertCite{humm;textual}{tvmComp}, using the date of payment. In an Ordinary Annuity, payments are made at the end of each payment period. In an Annuity Due, payments are made at the beginning of each payment period. Loan payments, mortgage payments, and interest payments on bonds are all examples of Ordinary Annuities.
The method \code{pvYearlyPaidAnnuityCompYearly()}is developed to compute Present Value(pv) of Yearly-Paid Ordinary Annuity or Annuity Due that is compounded Annually and gives PResent Value when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years, \code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments).
}
\examples{
pvYearlyPaidAnnuityCompYearly(0.06,12, -200, 1)
pvYearlyPaidAnnuityCompYearly(0.06,12, -200, 0)
pvYearlyPaidAnnuityCompYearly(0.06,12, 200, 1)
pvYearlyPaidAnnuityCompYearly(0.06,12, 200, 0)
}
\references{
\insertRef{humm}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
