% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{first.panel.gap}
\alias{first.panel.gap}
\title{first.panel.gap}
\usage{
first.panel.gap(
  dat,
  id.name = "id",
  t1.name = "t1",
  t2.name = "t2",
  gap.name = "gap_before",
  first.value = 0,
  expected.gap.between = 0,
  append.to.table = FALSE
)
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to track subjects
across multiple rows of data.}

\item{t1.name}{The character name of the time variable within dat representing the start (left endpoint)
of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the end (right endpoint)
of observation intervals.}

\item{gap.name}{A character value for the name of the variable to be used or created that specifies
whether a gap is observed before the record.}

\item{first.value}{The numeric value indicating the expected beginning time of the observation period for each subject.}

\item{expected.gap.between}{The numeric value indicating the expected amount of time between the end of one
record and the start of the next; the default is zero, assuming continuous observation.}

\item{append.to.table}{A logical value indicating whether the identified first gap times should be appended
as a new column to the existing data.frame (TRUE) or returned as a separate data frame (FALSE, default).}
}
\value{
If append.to.table is FALSE, the function returns a data table with the identified first gap time
for each subject, keyed by the id.name. Each subject will have a corresponding gap time, indicating the
first observed gap in their data. If append.to.table is TRUE, the original data table is returned with a
new column appended, containing the first gap times for each subject. This functionality is critical for
longitudinal studies where maintaining continuous observation of subjects is necessary, and identifying
gaps can highlight data collection issues or subject attrition.
}
\description{
Identifies the first occurrence of a gap in observation periods for each unique subject
within a panel data structure. A gap is defined as a period where no data were recorded for an
expected interval between observations.
}
