% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twfy.R
\name{getGeometry}
\alias{getGeometry}
\title{Return geometry information for a constituency}
\usage{
getGeometry(name)
}
\arguments{
\item{name}{Name of constituency}
}
\value{
A data.frame with columns \itemize{
 \item{\code{parts} }{number of connected parts of the constituency}
 \item{\code{area} }{area in square meters}
 \item{\code{min_lat} }{minimum latitude in the constituency}
 \item{\code{centre_lat} }{latitude of the central point of the constituency}
 \item{\code{max_lat} }{maximum latitude in the constituency}
 \item{\code{min_long} }{minimum longitude in the constituency}
 \item{\code{centre_long} }{longitude of the central point of the constituency}
 \item{\code{max_long} }{maximum longitude in the constituency}
 \item{\code{srid_n} }{}
 \item{\code{min_e} }{}
 \item{\code{centre_e} }{}
 \item{\code{max_e} }{}
 \item{\code{min_n} }{}
 \item{\code{centre_n} }{}
 \item{\code{max_n} }{}
}
}
\description{
From TheyWorkForYou: "This currently includes, for Great Britain,
the latitude and longitude of the centre point of the bounding box
of the constituency, its area in square meters, the bounding box itself
and the number of parts in the polygon that makes up the constituency.
For Northern Ireland, as we don't have any better data, it only returns
an approximate (estimated by eye) latitude and longitude for the
constituency's centroid."
}
