% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{coeff_trussell_ki}
\alias{coeff_trussell_ki}
\title{Coefficients for the estimation of child mortality multipliers \code{k(i)}}
\format{
A data frame
}
\usage{
data(coeff_trussell_ki)
}
\description{
This is a dataset of coefficients used to estimate multipliers \code{k(i)} in the TRUSSELL version of
the BRASS method, using Coale-Demeny mortality models.
}
\details{
The basic estimation equation for the Trussell method (equation 4.3) is

\deqn{k(i) = a(i) + b(i) P(1)/P(2) + c(i) P(2)/P(3)}
\itemize{
\item extracted from page 26, Table 4.
}
}
\references{
United Nations Population Studies (1990) Step-by-Step Guide
to the Estimation of Child Mortality No.107:1-83
(\href{https://www.un.org/en/development/desa/population/publications/pdf/mortality/stepguide_childmort.pdf}{United Nations})
}
\keyword{datasets}
