% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_model.R
\name{run_fnn}
\alias{run_fnn}
\title{Train a Feedforward Neural Network (FNN) in a Counterfactual Scenario.}
\usage{
run_fnn(train, test, params, calc_shaps)
}
\arguments{
\item{train}{A data frame or tibble containing the training dataset,
including the target variable (\code{value})
and meteorological variables specified in \code{params$meteo_variables}.}

\item{test}{A data frame or tibble containing the test dataset on which
predictions will be made,
using the same meteorological variables as in the training dataset.}

\item{params}{A list of parameters that define the following:
\describe{
\item{meteo_variables}{A character vector specifying the names of the
meteorological variables used as inputs.}
\item{fnn}{A list of hyperparameters for training the feedforward neural
network, including:
\itemize{
\item \code{activation_fun}: The activation function for the hidden
layers (e.g., "sigmoid", "tanh").
\item \code{momentum}: The momentum factor for training.
\item \code{learningrate_scale}: Factor for adjusting learning rate.
\item \code{output_fun}: The activation function for the output layer
\item \code{batchsize}: The size of the batches during training.
\item \code{hidden_dropout}: Dropout rate for the hidden layers to
prevent overfitting.
\item \code{visible_dropout}: Dropout rate for the input layer.
\item \code{hidden_layers}: A vector specifying the number of neurons
in each hidden layer.
\item \code{num_epochs}: Number of epochs (iterations) for training.
\item \code{learning_rate}: Initial learning rate.
}
}
}}

\item{calc_shaps}{Boolean value. If TRUE, calculate SHAP values for the
method used and format them so they can be visualised with
\code{\link[shapviz:sv_importance]{shapviz:sv_importance()}} and
\code{\link[shapviz:sv_dependence]{shapviz:sv_dependence()}}.
The SHAP values are generated for a subset (or all, depending on the size of the dataset) of the
test data.}
}
\value{
A list with three elements:
\describe{
\item{\code{dt_predictions}}{A data frame containing the test data along
with the predicted values:
\describe{
\item{\code{prediction}}{The predicted values from the FNN model.}
\item{\code{prediction_lower}}{The same predicted values, as no
quantile model is available yet for FNN.}
\item{\code{prediction_upper}}{The same predicted values, as no
quantile model is available yet for FNN.}
}
}
\item{\code{model}}{The trained FNN model object from the
\code{deepnet::nn.train()} function.}
\item{\code{importance}}{SHAP importance values (if
\code{calc_shaps = TRUE}). Otherwise, \code{NULL}.}
}
}
\description{
Trains a feedforward neural network (FNN) model on the
specified training dataset and makes predictions on the test dataset in a
counterfactual scenario. The model uses meteorological variables and
sin/cosine-transformed features. Scales the data before training and rescales
predictions, as the model does not converge with unscaled data.
}
\details{
This function provides flexibility for users with their own data pipelines
or workflows. For a simplified pipeline, consider using
\code{\link[ubair:run_counterfactual]{run_counterfactual()}}.

Experiment with hyperparameters such as \code{learning_rate},
\code{batchsize}, \code{hidden_layers}, and \code{num_epochs} to improve
performance.

Warning: Using many or large hidden layers in combination with a high number
of epochs can lead to long training times.
}
\examples{
data(mock_env_data)
params <- load_params()
res <- run_fnn(
  train = mock_env_data[1:80, ],
  test = mock_env_data[81:100, ], params,
  calc_shaps = FALSE
)
}
