% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn3.R
\name{bn3}
\alias{bn3}
\title{Computes Bn Statistic for 3 Groups.}
\usage{
bn3(group_id, md = NULL, data = NULL)
}
\arguments{
\item{group_id}{A vector of 1s, 2s and 3s indicating to which group the samples belong. Must be in the same order as data or md.}

\item{md}{Matrix of distances between all data points.}

\item{data}{Data matrix. Each row represents an observation.}
}
\value{
Value of the Bn3 statistic.
}
\description{
Returns the value for the Bn statistic that measures the degree of separation between three groups.
The statistic is computed as a combination of differences of average within group and between group distances.
Large values of Bn indicate large group separation. Under overall sample homogeneity we have E(Bn)=0.
}
\details{
Either \code{data} OR \code{md} should be provided.
If data are entered directly, Bn will be computed considering the squared Euclidean distance.

For more detail see
Bello, Debora Zava,  Marcio Valk and Gabriela Bettella Cybis.
 "Clustering inference in multiple groups." arXiv preprint arXiv:2106.09115 (2021).
}
\examples{
n=7
set.seed(1234)
x=matrix(rnorm(n*10),ncol=10)
bn3(c(1,2,2,2,3,3,3),data=x)     # option (a) entering the data matrix directly
md=as.matrix(dist(x))^2
bn3(c(1,2,2,2,3,3,3),md)         # option (b) entering the distance matrix
}
