% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uclust3.R
\name{uclust3}
\alias{uclust3}
\title{U-statistic based significance clustering for three way partitions}
\usage{
uclust3(md = NULL, data = NULL, alpha = 0.05, rep = 15)
}
\arguments{
\item{md}{Matrix of distances between all data points.}

\item{data}{Data matrix. Each row represents an observation.}

\item{alpha}{Significance level.}

\item{rep}{Number of times to repeat optimization procedures. Important for problems with
multiple optima.}
}
\value{
Returns a list with the following elements:\describe{
  \item{groups}{List with elements of final three groups}
  \item{p.value}{P-value for the test that renders the final partition, if heterogeneous.
  Homogeneity test p-value, if homogeneous.}
  \item{alpha_corrected}{Bonferroni corrected significance level for the test that renders the final
  partition, if heterogeneous. Homogeneity test significance level, if homogeneous.}
  \item{ishomo}{Logical, returns \code{TRUE} when the sample is homogeneous.}
  \item{Bn}{Value of Bn statistic for the final partition, if heterogeneous.
  Value of Bn statistic for the maximal homogeneity test partition, if homogeneous.}
  \item{varBn}{Variance estimate for final partition, if heterogeneous.
  Variance estimate for the maximal homogeneity test partition, if homogeneous.}
}
}
\description{
Partitions data into three groups only when these partitions are statistically significant.
 If no significant partition exists, the test will return "homogeneous".
}
\details{
This is the significance clustering procedure of Bello et al. (2021).
The method first performs a homogeneity test to verify whether the data can be significantly
partitioned. If the hypothesis of homogeneity is rejected, then the method will search, among all
the significant partitions, for the partition that better separates the data, as measured by larger
\code{bn} statistic. This function should be used in high dimension small sample size settings.


Either \code{data} or \code{md} should be provided.
If data are entered directly, Bn will be computed considering the squared Euclidean distance.

Variance of \code{bn} is estimated through resampling, and thus, p-values may vary a bit in different runs.

For more detail see
Bello, Debora Zava,  Marcio Valk and Gabriela Bettella Cybis.
 "Clustering inference in multiple groups." arXiv preprint arXiv:2106.09115 (2021).
See also \code{is_homo3}, \code{uclust}.
}
\examples{
set.seed(123)
x = matrix(rnorm(70000),nrow=7)  #creating homogeneous Gaussian dataset
res = uclust3(data=x)
res

# uncomment to run
# x = matrix(rnorm(15000),nrow=15)
# x[1:6,] = x[1:6,]+1.5 #Heterogeneous dataset (first 5 samples have different mean)
# x[7:12,] = x[7:12,]+3
# res = uclust3(data=x)
# res$groups

}
