% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr.omegasq.R
\name{pwr.omegasq}
\alias{pwr.omegasq}
\alias{print.pwr.omegasq}
\title{Power calculations for Omega Squared.}
\usage{
pwr.omegasq(
  k = NULL,
  n = NULL,
  omegasq = NULL,
  sig.level = 0.05,
  power = NULL,
  digits = 4
)

\method{print}{pwr.omegasq}(x, digits = x$digits, ...)
}
\arguments{
\item{k}{The number of groups.}

\item{n}{The sample size.}

\item{omegasq}{The Omega Squared value.}

\item{sig.level}{The significance level (alpha).}

\item{power}{The power.}

\item{digits}{The number of digits desired in the output (4, the default, is
quite high; but omega squared value tend to be quite low).}

\item{x}{The object to print.}

\item{...}{Additional arguments are ignored.}
}
\value{
An \code{power.htest.ufs} object that contains a number of input and
output values, most notably:

\item{power}{The (specified or computed) power} \item{n}{The (specified or
computed) sample size in each group} \item{sig.level}{The (specified or
computed) significance level (alpha)} \item{sig.level}{The (specified or
computed) Omega Squared value} \item{cohensf}{The computed value for the
Cohen's \emph{f} effect size measure}
}
\description{
This function uses \code{\link[pwr:pwr.anova.test]{pwr::pwr.anova.test()}} from the \link[pwr:pwr-package]{pwr::pwr-package}
package in combination with \code{\link[=convert.cohensf.to.omegasq]{convert.cohensf.to.omegasq()}} and
\code{\link[=convert.omegasq.to.cohensf]{convert.omegasq.to.cohensf()}} to provide power analyses for Omega
Squared.
}
\details{
This function was written to work similarly to the power functions in the
\link[pwr:pwr-package]{pwr::pwr-package} package.
}
\examples{

pwr.omegasq(omegasq=.06, k=3, power=.8)

}
\seealso{
\code{\link[pwr:pwr.anova.test]{pwr::pwr.anova.test()}},
\code{\link[=convert.cohensf.to.omegasq]{convert.cohensf.to.omegasq()}},
\code{\link[=convert.omegasq.to.cohensf]{convert.omegasq.to.cohensf()}}
}
\author{
Gjalt-Jorn Peters & Peter Verboon

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{htest}
