% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nmr_info}
\alias{nmr_info}
\title{Nightingale biomarker information}
\format{
A data table with 325 rows and 8 columns:
\describe{
  \item{Biomarker}{Short column name assigned to the biomarker}
  \item{Description}{Biomarker description, matching the description field provided by UK Biobank and Nightingale Health}
  \item{Units}{Units of measurement for the biomarker ("mmol/L", "g/L", "nm", "degree", "ratio", or "\%")}
  \item{Type}{Biomarker type ("Non-derived", "Composite", "Ratio", or "Percentage")}
  \item{Group}{Biomarker group as provided by Nightingale Health}
  \item{Sub.Group}{Biomarker sub-group as provided by Nightingale Health}
  \item{Nightingale}{Logical. Indicates biomarker is quantified by the Nightingale Health platform}
  \item{UKB.Field.ID}{Field ID in UK Biobank, see \url{https://biobank.ndph.ox.ac.uk/showcase/label.cgi?id=220}}
  \item{QC.Flag.Field.ID}{Field ID in UK Biobank for the biomarker QC Flags, see \url{https://biobank.ndph.ox.ac.uk/showcase/label.cgi?id=220}}
  \item{Full.Formula}{For composite biomarkers and ratios, details formula through which the biomarker can be derived from the 107 non-derived biomarkers}
  \item{Simplified.Formula}{Simplified form of the full formula most clearly expressing how each composite biomarker and ratio can be rederived from other biomarkers}
}
}
\usage{
nmr_info
}
\description{
Contains details on the Nightingale biomarkers available in UK Biobank and
computed by this package.
}
\keyword{datasets}
