% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{.load_peaklist_file}
\alias{.load_peaklist_file}
\title{Load a peaklist from file}
\usage{
.load_peaklist_file(path)
}
\arguments{
\item{path}{Character string. Path to the file to be read.}
}
\value{
A \code{data.table} containing the raw peaklist data.
}
\description{
Internal helper for \code{as_peaklist()} that reads a peaklist from a file.
Supports common tabular formats, including:
\itemize{
\item CSV (\code{.csv})
\item TSV (\code{.tsv}, \code{.txt})
\item RDS (\code{.rds})
}

Column names are not altered here; normalization happens later in
\code{as_peaklist()} via \code{.normalize_column_aliases()}.
}
\seealso{
Other peaklist helpers: 
\code{\link{.as_peaklist_from_numeric}()},
\code{\link{.filter_peaklist_basic}()}
}
\concept{peaklist helpers}
\keyword{internal}
