% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_library.R
\name{download_library}
\alias{download_library}
\title{Download and Load a UME Formula Library from Zenodo}
\usage{
download_library(
  library = "lib_05.rds",
  doi = "10.5281/zenodo.17606457",
  dest = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{library}{Character. One of \code{"lib_02.rds"} or \code{"lib_05.rds"}.}

\item{doi}{Character. Zenodo DOI.}

\item{dest}{Optional file path where the library should be saved.
If \code{NULL}, the library is \strong{loaded into memory only}.}

\item{overwrite}{Logical. Redownload even if \code{dest} exists?}
}
\value{
A \code{data.table} or \code{NULL} (in non-interactive mode).
}
\description{
Downloads one of the UME formula libraries from Zenodo \strong{only when explicitly
called by the user}.

Unlike earlier versions, this CRAN-compliant implementation:
\itemize{
\item \strong{never writes to the user's filespace unless \code{dest} is explicitly provided}
\item \strong{does NOT create ~/.ume/} or any other default directory
\item \strong{does NOT perform automatic caching}
\item In non-interactive environments (CRAN checks), the function \strong{returns NULL}
}
}
