% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_custom_formula_library.R
\name{create_custom_formula_library}
\alias{create_custom_formula_library}
\title{Create a custom molecular formula library for UltraMassExplorer}
\usage{
create_custom_formula_library(mf)
}
\arguments{
\item{mf}{Character vector of molecular formula(s)
(e.g., \code{c("C10H23NO4", "C10H24N4O2S")}).}
}
\value{
A \code{data.table} representing a fully constructed UME molecular formula
library. The returned table contains one row for each input molecular
formula and additional rows for its isotopologues (\verb{13C}, \verb{15N}, \verb{34S})
when applicable. Columns include:

\itemize{
\item \code{vkey} – unique integer identifier for each formula/isotopologue.
\item \code{mf} – reconstructed molecular formula string.
\item \code{mf_iso} – isotopologue formula string.
\item \code{nm} – nominal mass.
\item \code{mass} – exact mass.
\item Element count columns (e.g., \verb{12C}, \verb{13C}, \verb{1H}, \verb{14N}, \verb{15N}, \verb{32S}, \verb{34S}).
}

The library is sorted by exact mass and includes all input formulas plus any
automatically constructed isotopologues.
}
\description{
Builds a library based on a list of molecular formulas.
The main stable isotope masses 13C1, 15N1, and 34S1 are automatically added.
}
\seealso{
Other internal functions: 
\code{\link{extract_aquisition_params}()},
\code{\link{extract_aquisition_params_from_folder}()},
\code{\link{extract_metadata_from_ufz_files}()},
\code{\link{read_xml_peaklist}()}
}
\author{
Boris Koch
}
\concept{internal functions}
\keyword{internal}
\keyword{misc}
