% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_mf_data}
\alias{filter_mf_data}
\title{Filter molecular formula data by mass spectrometric metadata}
\usage{
filter_mf_data(
  mfd,
  c_iso_check = FALSE,
  n_iso_check = FALSE,
  s_iso_check = FALSE,
  ma_dev = 3,
  dbe_max = 999,
  dbe_o_min = -999,
  dbe_o_max = 999,
  mz_min = 1,
  mz_max = 9999,
  n_min = 0,
  n_max = 999,
  s_min = 0,
  s_max = 999,
  p_min = 0,
  p_max = 999,
  oc_min = 0,
  oc_max = 999,
  hc_min = 0,
  hc_max = 999,
  nc_min = 0,
  nc_max = 99,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{c_iso_check}{(TRUE / FALSE); check if formulas are verified by the presence of the main daughter isotope}

\item{n_iso_check}{(TRUE / FALSE); check if formulas are verified by the presence of the main daughter isotope}

\item{s_iso_check}{(TRUE / FALSE); check if formulas are verified by the presence of the main daughter isotope}

\item{ma_dev}{Deviation range of mass accuracy in +/- ppm (default: 3 ppm)}

\item{dbe_max}{Maximum number for DBE}

\item{dbe_o_min}{Minimum number for DBE minus O atoms}

\item{dbe_o_max}{Maximum number for DBE minus O atoms}

\item{mz_min}{Minimum of mass to charge value}

\item{mz_max}{Maximum of mass to charge value}

\item{n_min}{Minimum number of nitrogen atoms}

\item{n_max}{Maximum number of nitrogen atoms}

\item{s_min}{Minimum number of nitrogen atoms}

\item{s_max}{Maximum number of nitrogen atoms}

\item{p_min}{Minimum number of nitrogen atoms}

\item{p_max}{Maximum number of nitrogen atoms}

\item{oc_min}{Minimum atomic ratio of oxygen / carbon}

\item{oc_max}{Maximum atomic ratio of oxygen / carbon}

\item{hc_min}{Minimum atomic ratio of hydrogen / carbon}

\item{hc_max}{Maximum atomic ratio of hydrogen / carbon}

\item{nc_min}{Minimum atomic ratio of nitrogen / carbon}

\item{nc_max}{Maximum atomic ratio of nitrogen / carbon}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
data.table; subset of original molecular formula table
}
\description{
This function filters molecular formulas by isotope numbers, element ratios, etc.
}
\examples{
filter_mf_data(mfd = mf_data_demo, dbe_o_max = 10)
}
\seealso{
Other Formula subsetting: 
\code{\link{filter_int}()},
\code{\link{filter_mass_accuracy}()},
\code{\link{remove_blanks}()},
\code{\link{subset_known_mf}()},
\code{\link{ume_assign_formulas}()},
\code{\link{ume_filter_formulas}()}
}
\author{
Boris P. Koch
}
\concept{Formula subsetting}
\keyword{misc}
