% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_dbe_vs_c.R
\name{uplot_dbe_vs_c}
\alias{uplot_dbe_vs_c}
\title{Plot DBE vs Carbon Atoms}
\usage{
uplot_dbe_vs_c(
  df,
  z_var = "norm_int",
  palname = "redblue",
  col_bar = TRUE,
  tf = FALSE,
  logo = TRUE,
  gg_size = 12,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{df}{A data.table containing columns:
\verb{12C}, \code{dbe}, and the variable given in \code{z_var}.}

\item{z_var}{Variable used for color coding (default \code{"norm_int"}).}

\item{palname}{Color palette name for f_colorz() (viridis, magma, plasma, etc.).}

\item{col_bar}{Logical. If \code{TRUE}, adds a color legend (default is \code{TRUE}).}

\item{tf}{Logical. If \code{TRUE}, applies a transformation to the color scale (default is \code{FALSE}).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{plotly}{If TRUE, returns a plotly interactive plot.}

\item{...}{
  Arguments passed on to \code{\link[=f_colorz]{f_colorz}}
  \describe{
    \item{\code{z}}{Numeric vector. Values whose colors should be computed.}
    \item{\code{col_num}}{Integer. Number of colors in the palette (default: \code{100}).}
    \item{\code{verbose}}{logical; if \code{TRUE}, show progress messages.}
  }}
}
\value{
A ggplot2 object or a plotly object (if \code{plotly = TRUE}).
}
\description{
Creates a scatter plot of DBE (double bond equivalents) vs. number of carbon
atoms. Points are color-coded by a selected variable (\code{z_var}). The plot
follows the same stylistic conventions as the other uplot_* functions,
including the unified theme and optional UME caption.
}
\examples{
uplot_dbe_vs_c(mf_data_demo, z_var = "norm_int")

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
