% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{BarcodeFamilyHistogram}
\alias{BarcodeFamilyHistogram}
\title{Consensus depth histograms}
\usage{
BarcodeFamilyHistogram(
  object,
  xMin = 0,
  xMax = 100,
  samples = NULL,
  option = "viridis",
  direction = 1,
  theme = "classic"
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object}

\item{xMin}{Minimum consensus family size to plot, default is 0.}

\item{xMax}{Maximum consensus family size to plot. Default is 100.}

\item{samples}{List of samples to be shown.}

\item{option}{Color scheme to use}

\item{direction}{If using viridis colors sets the orientation of color scale.}

\item{theme}{ggplot theme to use. Defaults to classic.}
}
\value{
A ggplot object
}
\description{
Generate histograms for the frequency of barcode family depths.
}
\examples{
library(umiAnalyzer)
main = system.file('extdata', package = 'umiAnalyzer')
simsen <- createUmiExperiment(main, importBam = TRUE)
barcode_dist <- BarcodeFamilyHistogram(simsen)

}
