% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{createUmiSample}
\alias{createUmiSample}
\title{createUmiSample}
\usage{
createUmiSample(sampleName, sampleDir, importBam = FALSE)
}
\arguments{
\item{sampleName}{UMI sample object name}

\item{sampleDir}{Path to UMI sample folders. Must be a folder generated by UMIErrorCorrect}

\item{importBam}{Logical. Should BAM files be imported at object initialization? Default is False.}
}
\value{
An object of class UMIsample
}
\description{
Method for creating a UMI sample from UMIErrorCorrect output.
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')
samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)
s1 <- createUmiSample('s1',sampleDir = paste(main,"/",samples[1],sep=""))

}
