% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getMetaData}
\alias{getMetaData}
\title{Retrieve meta data by name.}
\usage{
getMetaData(object, attributeName)
}
\arguments{
\item{object}{R object from which to get meta data.}

\item{attributeName}{Name of the meta data attribute.}
}
\value{
Metadata
}
\description{
Retrieve meta data by name.
}
\examples{
\donttest{
library(umiAnalyzer)

main <- system.file("extdata", package = "umiAnalyzer")

simsen <- createUmiExperiment(main)

metaData <- system.file("extdata", "metadata.txt", package = "umiAnalyzer")

simsen <- importDesign(object = simsen,file = metaData)
design <- getMetaData(object = simsen, attributeName = "design")
design
}

}
