print.uncertainty <-
function(x, ...) {
	ndigits <- options("ndigits")[[1]]
	if (is.null(ndigits)) ndigits <- 2
	cat(paste0("measurand: ", x$measurand_name))
	cat(paste0(	"\ndescription: ", x$measurand_description))
	cat(paste0(	"\nmodel: ", x$measurand_model, "\n"))
	cat(paste0(	"\n  value = ", .format_value(matrix(c(x$mean, x$u), 1, 2), ndigits)[1, 1], " ", x$unit))
	cat(paste0(	"\n U(", signif(100 * (1 - x$alpha), ndigits), "%) = ", signif(x$U, ndigits), " ", x$unit, "\n"))
	cat(paste0(	" ", 100 * (1 - x$alpha), "% CI = (", .format_value(matrix(c(x$lcl, x$u), 1, 2), ndigits)[1, 1]))
	cat(paste0(	", ", .format_value(matrix(c(x$ucl, x$u), 1, 2), ndigits)[1, 1], ")", " ", x$unit, "\n"))
	if (!is.na(x$Upct)) cat(paste0("U%(", signif(100 * (1 - x$alpha), ndigits), "%) = ", signif(x$Upct, ndigits)))
#	cat(paste0("\n     sd = ", signif(x$sd, ndigits)))
	cat(paste0("\n      u = ", signif(x$u, ndigits), " ", x$unit))
	cat(paste0(	"\n      k = ", .format_value(matrix(c(qt(1-x$alpha/2, x$dof), x$u), 1, 2), ndigits)[1, 1]))
	cat(paste0(	"\n    dof = ", signif(x$dof, ndigits), "\n"))
}
