% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_mf_all.R
\name{annotate_mf_all}
\alias{annotate_mf_all}
\title{Annotate meaningful formatting for all cells}
\usage{
annotate_mf_all(xlfilepath)
}
\arguments{
\item{xlfilepath}{Path to a single-sheet spreadsheet file (xls or xlsx).}
}
\value{
A tibble with meaningful formatting embedded as text for all rows and
columns.
}
\description{
Turns cell formatting into annotations for all values across all variables.
}
\details{
Seven popular approaches for meaningful formatting (bold, colored
text, italic, strikethrough, underline, double underline, and cell
highlighting) are supported in this function. \code{sheets}, \code{skip}, and \code{range}
arguments for spreadsheet input are not supported. The hex8 code of the
fill color used for text color and cell highlighting is also appended in
the output. Ensure the data in the spreadsheet are rectangular before
running; this includes blank but formatted cells beyond the data rectangle.
}
\examples{
example_spreadsheet <- system.file("extdata/boutiques.xlsx", package = "unheadr")
annotate_mf_all(example_spreadsheet)
}
