% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cornell.R
\docType{data}
\name{cornell_3_accent}
\alias{cornell_3_accent}
\title{Accent colors of Cornell University, USA}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on \href{https://www.cornell.edu}{Cornell}'s 
\href{https://brand.cornell.edu/design-center/colors/}{Color manual}.
}
\usage{
cornell_3_accent
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{cornell_3_accent} provides the nine primary colors
of \href{https://www.cornell.edu}{Cornell University}, USA.
}
\details{
The 9 secondary colors are 
\code{"Cornell blue"} (defined as HEX #006699),
\code{"Cornell green graphics"} (defined as HEX #6EB43F),
\code{"Cornell green text"} (defined as HEX #4B7B2B),
\code{"Cornell green text big"} (defined as HEX #578E32),
\code{"Cornell orange graphics"} (defined as HEX #F8981D),
\code{"Cornell orange text"} (defined as HEX #D47500),
\code{"Cornell red graphics"} (defined as HEX #EF4035),
\code{"Cornell red text"} (defined as HEX #DF1E12), and
\code{"Cornell navy"} (defined as HEX #073949).


Although the primary and secondary color palettes 
(see \code{\link{cornell_1}} and \code{\link{cornell_2}}) 
should guide most layouts, in certain instances other colors may be needed.

For those circumstances, refer to the accent palette (\code{cornell_3_accent}). 
These colors should not be used as full-color bleeds and should be used 
periodically and in moderation.
}
\examples{
cornell_3_accent
unikn::seecol(cornell_3_accent, main = "Accent colors of Cornell University")  # view palette

}
\seealso{
\code{\link{cornell_1}} for primary colors of Cornell University;
\code{\link{cornell_2}} for primary colors of Cornell University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
