% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_brand}
\alias{oxford_brand}
\title{Brand colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_brand
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_brand} provides the four brand colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The (dark) Oxford blue is used primarily in general page furniture 
such as the backgrounds on the header and footer.
This makes for a strong brand presence throughout the site. 
Because it features so strongly in these areas, 
it is not recommended to use it in large areas elsewhere. 
However it is used more sparingly in smaller elements 
such as in event date icons and search/filtering bars.

The brand colours are
\code{"primary"} (defined as HEX #002147),
\code{"secondary"} (defined as HEX #a79d96),
\code{"tertiary"} (defined as HEX #f3f1ee), and
\code{"light_primary"} (defined as HEX #122f53).
}
\examples{
oxford_brand
unikn::seecol(oxford_brand, main = "Uni Oxford brand colours") # view colour palette

}
\seealso{
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
