% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cork.R
\docType{data}
\name{ucc_2}
\alias{ucc_2}
\title{Secondary colours of the University College Cork, Ireland}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on \href{https://www.ucc.ie/en/}{UCC}'s 
\href{https://www.ucc.ie/en/marketing-brand/}{Visual identity guidelines} 
(PDF of 2017, p. 26f.).
}
\usage{
ucc_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ucc_2} provides the eight secondary colours 
of the \href{https://www.ucc.ie/en/}{University College Cork}, Ireland.
}
\details{
See \code{ucc_2} for names and values, based on HEX color definitions.


The secondary colour palette is made up of natural colours 
from around Cork and the \href{https://www.ucc.ie/en/}{UCC} campus.

To be used at a college level and on uncoated paper.

For use on coated paper, the use of a 90% tint of 
the Pantone variants of \code{Dawn mauve} and \code{Earth red} is permitted. 

Please do not use tints of the colours except on the colours indicated.
}
\examples{
ucc_2
unikn::seecol(ucc_2, col_bg = "grey90", 
              main = "Secondary colours of the University College Cork") # view color palette
              
}
\seealso{
\code{\link{ucc_1}} for primary colours of the University College Cork;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2023-09-09.
}
\concept{Irish university color palettes}
\keyword{datasets}
