% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateML-package.R
\docType{package}
\name{univariateML-package}
\alias{univariateML}
\alias{univariateML-package}
\title{univariateML}
\description{
An \code{R}-package for fast, easy, and reliable maximum likelihood
estimation for a selection of parametric univariate densities.
}
\details{
Data analysis often requires the estimation of univariate densities.
Maximum likelihood estimation is sensible for almost every univariate
density used in practice. Moreover, the maximum likelihood estimator is
typically consistent and efficient.

The purpose of this package is to
\itemize{
\item Support maximum likelihood estimation of a large selection of
densities.
\item Supports plenty of generics such as \code{plot} and \code{AIC} to
aid your data analysis.
}

Read the vignettes to learn more about univariateML:
\code{browseVignettes(package = "univariateML")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/JonasMoss/univariateML}
  \item \url{https://jonasmoss.github.io/univariateML/}
  \item Report bugs at \url{https://github.com/JonasMoss/univariateML/issues}
}

}
\author{
\strong{Maintainer}: Jonas Moss \email{jonas.gjertsen@gmail.com} (\href{https://orcid.org/0000-0002-6876-6964}{ORCID})

Other contributors:
\itemize{
  \item Thomas Nagler \email{mail@tnagler.com} [contributor]
  \item Chitu Okoli \email{chitu.okoli@skema.edu} [contributor]
}

}
