% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count_path_segments}
\alias{count_path_segments}
\title{Count occurrences of specific path segments at a given index}
\usage{
count_path_segments(path, segment_index, sort = FALSE, name = "n")
}
\arguments{
\item{path}{A character vector of paths.}

\item{segment_index}{Index of the segment to count.}

\item{sort}{Logical indicating whether to sort the output by count. Defaults
to FALSE.}

\item{name}{The name of the column containing the counts. Defaults to 'n'.}
}
\value{
A tibble with each segment at the specified index and how often it occurs.
}
\description{
Count occurrences of specific path segments at a given index
}
\examples{
count_path_segments(c("/path/to/resource", "/path/to/shop"), 2)
}
