% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ncbirths_tbl_df}
\alias{ncbirths_tbl_df}
\title{North Carolina births, 1000 cases}
\format{
A tibble with 1000 observations and 13 variables:
\describe{
  \item{fage}{Integer representing the father's age.}
  \item{mage}{Integer representing the mother's age.}
  \item{mature}{Factor with 2 levels indicating if the mother is mature (>=35 years).}
  \item{weeks}{Integer representing the number of gestation weeks.}
  \item{premie}{Factor with 2 levels indicating if the baby was born prematurely.}
  \item{visits}{Integer representing the number of prenatal visits.}
  \item{marital}{Factor with 2 levels indicating the marital status of the mother.}
  \item{gained}{Integer representing the mother's weight gain during pregnancy (in pounds).}
  \item{weight}{Numeric value representing the baby's birth weight (in grams).}
  \item{lowbirthweight}{Factor with 2 levels indicating if the baby was born with low birth weight.}
  \item{gender}{Factor with 2 levels indicating the baby's gender.}
  \item{habit}{Factor with 2 levels indicating if the mother has a smoking habit.}
  \item{whitemom}{Factor with 2 levels indicating if the mother is white.}
}
}
\source{
Data from birth records in North Carolina
}
\usage{
data(ncbirths_tbl_df)
}
\description{
The dataset name has been changed to 'ncbirths_tbl_df' to avoid confusion with other packages
in the R ecosystem. This naming convention helps distinguish this dataset as part of the 'usdatasets'
package and identifies it as a tibble. The original content of the dataset has not been modified.
}
