% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{derivative}
\alias{derivative}
\title{Computes the derivative of a function}
\usage{
derivative(x, coeffs, degree = 1, ndx = 20, deg = 6)
}
\arguments{
\item{x}{the x values for which the derivative should be computed.}

\item{coeffs}{the coefficient.}

\item{degree}{the degree of the derivative.}

\item{ndx}{number of intervals to partition the distance between the lowest and highest x-values of the utility points.}

\item{deg}{degree of the B-spline basis. Determines the degree of the function to be estimated. If deg = 2, the estimated utility function will consist of quadratic functions.}
}
\value{
the derivative of the specified degree.
}
\description{
Computes the derivative of a function
}
\examples{
coeffs <- seq(0.000002, 1.0, (1.0 - 0.000002) / 25)
x <- seq(0.01, 1.0, (1.0 - 0.01) / 5)
derivative(x, coeffs)
}
