% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_means_between_groups.R
\name{compare_means_between_groups}
\alias{compare_means_between_groups}
\title{Compare Means Between Groups}
\usage{
compare_means_between_groups(
  data,
  var1,
  var2,
  variable,
  grouping_variable,
  groups,
  test = "Welch",
  input = "wide",
  output = "console"
)
}
\arguments{
\item{data}{data}

\item{var1}{variable 1}

\item{var2}{variable 2}

\item{variable}{variable}

\item{grouping_variable}{Group}

\item{groups}{Specify groups from grouping variable}

\item{test}{Default: "Welch", choose between "student" and "Welch"}

\item{input}{Default: "wide", choose between "long" and "wide". "wide" requires data var1 var2. "long" requires data, variable, grouping_variable groups}

\item{output}{Default: "console" - prints output in console and returns tibble invisibly.}
}
\value{
results
}
\description{
Compare Means Between Groups
}
\examples{

# Wide data - default
data_wide <- data.frame(A = c(4, 2, 5, 3, 6, 2, 5),
                        B = c(5, 2, 1, 2, 1, 3, 2))

compare_means_between_groups(data_wide, var1 = A, var2 = B)

# Long data
data_long <- data_wide |> tibble::rowid_to_column("id") |>
  tidyr::pivot_longer(cols = -id, names_to = "group", values_to = "variable")

compare_means_between_groups(data_long, variable = variable,
                             grouping_variable = group, groups = c("A", "B"), input = "long")
}
