% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_rates_between_groups.R
\name{compare_rates_between_groups}
\alias{compare_rates_between_groups}
\title{Compare Rates Between Groups}
\usage{
compare_rates_between_groups(
  data,
  group,
  event,
  test,
  input = "long",
  output = "console"
)
}
\arguments{
\item{data}{data}

\item{group}{column in dataframe : group}

\item{event}{column in dataframe : event}

\item{test}{Type of test (fisher, n-1 two prop)}

\item{input}{Defaults to "long"}

\item{output}{"console" prints output to console; "tibble" returns tibble}
}
\value{
results
}
\description{
Compare Rates Between Groups
}
\examples{
design = c("A","B")
complete = c(34, 24)
incomplete = c(317, 301)
data <- data.frame(design, complete, incomplete)
data <- data |> tidyr::pivot_longer(!design, names_to = "rate", values_to = "n") |>
  tidyr::uncount(n)
compare_rates_between_groups(data, group = design, event = rate)
}
