% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valhalla.R
\name{od_table}
\alias{od_table}
\title{Generate Tidy Origin-Destination Data using Valhalla}
\usage{
od_table(
  froms,
  from_id_col,
  tos,
  to_id_col,
  costing = "auto",
  batch_size = 100,
  minimum_reachability = 500,
  verbose = FALSE,
  hostname = "localhost",
  port = 8002
)
}
\arguments{
\item{froms}{A tibble containing origin locations in columns named \code{lat} and
\code{lon}, and an optional column with human-readable names.}

\item{from_id_col}{The name of the column in \code{froms} that contains
human-readable names.}

\item{tos}{A tibble containing destination locations in columns named \code{lat}
and \code{lon}, and an optional column with human-readable names.}

\item{to_id_col}{The name of the column in \code{tos} that contains human-readable
names.}

\item{costing}{The travel costing method: at present "auto", "bicycle", and
"pedestrian" are supported.}

\item{batch_size}{The number of origin points to process per API call.}

\item{minimum_reachability}{The minimum number of nodes a candidate network
needs to have before it is included. Try increasing this value (e.g. to
500) if Valhalla is getting stuck in small disconnected road networks.}

\item{verbose}{Boolean. Defaults to FALSE. If TRUE, it will provide updates on
on the batching process (if applicable).}

\item{hostname}{Hostname or IP address of your Valhalla instance. Defaults to "localhost".}

\item{port}{The port your Valhalla instance is monitoring. Defaults to 8002.}
}
\value{
A tibble showing the trip distances and times from each origin to each named destination.
}
\description{
This function creates a tidy (i.e. long) table of
origin-destination trip data using the Valhalla routing engine. For a set
of o origins and d destinations, it returns a tibble with (o x d) rows with
the travel distance and time between each pair. It can handle several
different travel modes and routing options.

This function is a user-friendly wrapper around\code{valhalla::sources_to_targets()},
which calls the Valhalla API directly. \code{sources_to_targets()} offers finer-
grained control over API options, and so this latter function may be more
useful for advanced users.

Notable features of \code{od_matrix()}:
\itemize{
\item You can specify human-readable indices with \code{from_id_col} and
\code{to_id_col}. (Valhalla's API only returns zero-indexed integer
identifiers.)
\item You can specify a \code{batch_size} to break computation into
several smaller API calls, to prevent your Valhalla instance from running
out of memory. This seems especially important for pedestrian routing,
where I've sometimes needed to use a batch size as small as 5.
}
}
\examples{
\dontrun{
library(dplyr)
library(valhallr)
# set up our inputs
origins <- bind_rows(test_data("parliament"), test_data("uottawa"), test_data("cntower"))
destinations <- bind_rows(test_data("cdntirecentre"), test_data("parliament"))

# generate a tidy origin-destination table
od <- od_table (froms = origins,
                from_id_col = "name",
                tos = destinations,
                to_id_col = "name",
                costing = "auto",
                batch_size = 100,
                minimum_reachability = 500)
}
}
