% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateLabel.R
\name{validateLabel}
\alias{validateLabel}
\title{Create validation tasks for labels assigned to the topics in the topic model of choice.}
\usage{
validateLabel(
  type,
  n,
  text.predict = NULL,
  text.name = "text",
  top1.name = "top1",
  top2.name = "top2",
  top3.name = "top3",
  labels = NULL,
  labels.index = NULL,
  labels.add = NULL
)
}
\arguments{
\item{type}{Task structures to be specified. Must be one of "LI" (Label Intrusion) 
and "OL" (Optimal Label).}

\item{n}{The number of desired tasks}

\item{text.predict}{A data frame or matrix containing both the text and the indicator(s)
of the model predicted topic(s).}

\item{text.name}{variable name in `text.predict` that indicates the text}

\item{top1.name}{variable name in `text.predict` that indicates the top1 model predicted topic}

\item{top2.name}{variable name in `text.predict` that indicates the top2 model predicted topic}

\item{top3.name}{variable name in `text.predict` that indicates the top3 model predicted topic}

\item{labels}{The user-defined labels assigned to the topics}

\item{labels.index}{The topic index in correspondence with the labels, e.g., c(10, 12, 15).
Must be in the same length and order with `label`.}

\item{labels.add}{Labels from other broad catagories. Default to NULL. Users could 
specify them to evaluate how well different broad categories are distinguished from
one another.

#' value A matrix containing the validation tasks as described in the return section.}
}
\value{
A matrix containing the validation tasks. The matrix has six value columns: 
  \describe{
    \item{topic}{The topic index associated with the document.}
    \item{doc}{The text of the document.}
    \item{opt1}{The first option label presented to the user.}
    \item{opt2}{The second option label presented to the user.}
    \item{opt3}{The third option label presented to the user.}
    \item{optcrt}{The correct label for the document.}
  }
}
\description{
Create validation tasks for labels assigned to the topics in the topic model of choice.
}
\details{
Users need to pick a topic model that they deem to be good and label the topics 
they later would like to use as measures.
}
