% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_check.R
\name{write_ratio_check}
\alias{write_ratio_check}
\alias{suggest_ratio_check}
\title{Suggest ratio checks}
\usage{
write_ratio_check(
  d,
  vars = names(d),
  file = stdout(),
  lin_cor = 0.95,
  digits = 2
)

suggest_ratio_check(d, vars = names(d), lin_cor = 0.95, digits = 2)
}
\arguments{
\item{d}{\code{data.frame}, used to generate the checks}

\item{vars}{\code{character} optionally the subset of variables to be used.}

\item{file}{file to which the checks will be written to.}

\item{lin_cor}{threshold for abs correlation to be included (details)}

\item{digits}{number of digits for rounding}
}
\value{
\code{suggest_ratio_check} returns \code{\link[validate:validator]{validate::validator()}} object with the suggested rules.
\code{write_ratio_check} write the rules to file and returns invisibly a named list of check for each variable.
}
\description{
Suggest ratio checks
}
\examples{
data(SBS2000, package="validate")

# generates upper and lower checks for the
# ratio of two variables if their correlation is
# bigger then `lin_cor`
suggest_ratio_check(SBS2000, lin_cor=0.98)
}
