% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rmse}
\alias{rmse}
\title{rmse}
\usage{
rmse(o, p)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}
}
\value{
Root mean square error (RMSE)
}
\description{
Calculates the Root mean square error (RMSE) from observed and
predicted values.
}
\details{
Interpretation: smaller is better. RMSE is sometimes abbreviated RMS, RMSD
or RMSEP. A smaller value means a smaller error. RMSE is similar to mean
absolute error (MAE), median absolute deviation (MAD) and root median squared error (RmdSE) but is
more sensitive to large errors.
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 2, 4, 5, 6, 8, 7, 10)
rmse(o=obs, p=pred)

}
\references{
Piikki K., Wetterlind J., Soderstrom M., Stenberg B. (2021). Perspectives
on validation in digital soil mapping of continuous attributes. A review.
Soil Use and Management. \doi{10.1111/sum.12694}
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
