% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CALplot.R
\encoding{UTF-8}
\name{CALplot}
\alias{CALplot}
\title{Calibration graph}
\usage{
CALplot(mat, by = 0.1)
}
\arguments{
\item{mat}{A matrix with two columns. The first column must contain the
suitability values (i.e., the classification rule); the second column must
contain the presences and absences.}

\item{by}{Size of the suitability intervals (bins). By default,
\code{by} = 0.1.}
}
\value{
This function returns a calibration plot
}
\description{
A function to plot a calibration graph.
}
\details{
Dots for bins with 15 or more cases are shown in solid black; dots
for bins with less than 15 cases are shown empty (see Jiménez-Valverde et
al. 2013). This way, by plotting the calibration graph before running
\code{\link{AUCuniform}}, one can get a glimpse of how reliable \emph{uAUC}
or \emph{uSe*} can be expected to be.
}
\examples{
suit<-rbeta(100, 2, 2) # Generate suitability values
random<-runif(100)
sp<-ifelse(random < suit,1 , 0) # Generate presence-absence data
CALplot(cbind(suit, sp))
}
\references{
Jiménez-Valverde, A., Acevedo, P., Barbosa, A. M., Lobo, J. M. &
    Real, R. (2013).  Discrimination capacity in species distribution models
    depends on the representativeness of the environmental domain.
    \emph{Global Ecol. Biogeogr.}, 22, 508-516.
}
