% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_palette_scores.R
\docType{data}
\name{vangogh_cvd_scores}
\alias{vangogh_cvd_scores}
\title{CVD Accessibility Scores for Van Gogh Palettes}
\format{
A data frame with CVD accessibility metrics:
\describe{
\item{palette}{Name of the Van Gogh palette}
\item{cvd_type}{Type of colour vision deficiency}
\item{min_distance}{Minimum CIELAB distance between colours (higher = more distinguishable)}
\item{accessibility}{Rating: Poor, Fair, Good, or Excellent}
\item{overall_rating}{Average accessibility across all CVD types}
}
}
\usage{
vangogh_cvd_scores
}
\description{
Pre-computed CVD accessibility scores for all Van Gogh palettes.
This data is generated by running check_all_vangogh_cvd() and is included
for quick reference without requiring the colorspace package.
}
\details{
Distance interpretation:
\itemize{
\item < 10: Poor - colours may be indistinguishable
\item 10-20: Fair - some difficulty distinguishing
\item 20-40: Good - generally distinguishable
\item > 40: Excellent - highly distinguishable
}
}
\examples{
\dontrun{
# View CVD scores
data(vangogh_cvd_scores)

# Find most accessible palettes
palette_summary <- aggregate(
  min_distance ~ palette, 
  data = vangogh_cvd_scores, 
  FUN = mean
)
palette_summary[order(-palette_summary$min_distance), ]

# Filter by CVD type
deutan_scores <- vangogh_cvd_scores[
  vangogh_cvd_scores$cvd_type == "Deuteranopia (red-green)", 
]
deutan_scores[order(-deutan_scores$min_distance), ]
}

}
\keyword{datasets}
