% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_est.R
\name{variance_est}
\alias{variance_est}
\title{Variance estimation for sample surveys by the ultimate cluster method}
\usage{
variance_est(
  Y,
  H,
  PSU,
  w_final,
  N_h = NULL,
  fh_zero = FALSE,
  PSU_level = TRUE,
  PSU_sort = NULL,
  period = NULL,
  dataset = NULL,
  msg = "",
  checking = TRUE
)
}
\arguments{
\item{Y}{Variables of interest. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{H}{The unit stratum variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{PSU}{Primary sampling unit variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{w_final}{Weight variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{N_h}{Number of primary sampling units in population for each stratum (and period if \code{period} is not \code{NULL}). If \code{N_h = NULL} and \code{fh_zero = FALSE} (default), \code{N_h} is estimated from sample data as sum of weights (\code{w_final}) in each stratum (and period if \code{period} is not \code{NULL}).
Optional for single-stage sampling design as it will be estimated from sample data. Recommended for multi-stage sampling design as \code{N_h} can not be correctly estimated from the sample data in this case. If \code{N_h} is not used in case of multi-stage sampling design (for example, because this information is not available), it is advisable to set \code{fh_zero = TRUE}.
If \code{period} \bold{is} \code{NULL}. A two-column matrix with rows for each stratum. The first column should contain stratum code. The second column - the number of primary sampling units in the population of each stratum.
If \code{period} \bold{is not} \code{NULL}. A three-column matrix with rows for each intersection of strata and period. The first column should contain period. The second column should contain stratum code. The third column - the number of primary sampling units in the population of each stratum and period.}

\item{fh_zero}{by default FALSE; \code{fh} is calculated as division of n_h and N_h in each strata, if TRUE, \code{fh} value is zero in each strata.}

\item{PSU_level}{by default TRUE; if PSU_level is TRUE, in each strata \code{fh} is calculated as division of count of PSU in sample (n_h) and count of PSU in frame (N_h). if PSU_level is FALSE, in each strata \code{fh} is calculated as division of count of units in sample (n_h) and count of units in frame (N_h), which calculated as sum of weights.}

\item{PSU_sort}{optional; if PSU_sort is defined, then variance is calculated for systematic sample.}

\item{period}{Optional variable for the survey periods. If supplied, the values for each period are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{dataset}{an optional name of the individual dataset  \code{data.table}.}

\item{msg}{an optional printed text, when function print error.}

\item{checking}{Optional variable if this variable is TRUE, then function checks data preparation errors, otherwise not checked. This variable by default is TRUE.}
}
\value{
a \code{data.table} containing the  values of the variance estimation by totals.
}
\description{
Computes the variance estimation by the ultimate cluster method.
}
\details{
If we assume that \eqn{n_h \geq 2}{n_h>=2} for all \eqn{h}, that is, two or more PSUs are selected from each stratum, then the variance of \eqn{\hat{\theta}}{\theta} can be estimated from the variation among the estimated PSU totals of the variable \eqn{Z}:
\deqn{\hat{V} \left(\hat{\theta} \right)=\sum\limits_{h=1}^{H} \left(1-f_h \right) \frac{n_h}{n_{h}-1} \sum\limits_{i=1}^{n_h} \left( z_{hi\bullet}-\bar{z}_{h\bullet\bullet}\right)^2, }{V(\theta)=\sum h=1...H  (1-f_h)*n_h/(n_h-1)* \sum  i=1...n_h ( z_hi.- z_h..)^2, }

where
\eqn{\bullet}{}
\eqn{z_{hi\bullet}=\sum\limits_{j=1}^{m_{hi}} \omega_{hij} z_{hij}}{z_hi.=\sum j=1...m_hi \omega_hij * z_hij}

\eqn{\bullet}{}
\eqn{\bar{z}_{h\bullet\bullet}=\frac{\left( \sum\limits_{i=1}^{n_h} z_{hi\bullet} \right)}{n_h}}{z_h..=(\sum i=1...n_h z_hi.)/n_h}

\eqn{\bullet}{}
\eqn{f_h} is the sampling fraction of PSUs within stratum

\eqn{\bullet}{}
\eqn{h} is the stratum number, with a total of H strata

\eqn{\bullet}{}
\eqn{i} is the primary sampling unit (PSU) number within stratum \eqn{h}, with a total of \eqn{n_h} PSUs

\eqn{\bullet}{}
\eqn{j} is the household number within cluster \eqn{i} of stratum \eqn{h}, with a total of \eqn{m_{hi}}{m_hi} household

\eqn{\bullet}{}
\eqn{w_{hij}}{w_hij} is the sampling weight for household \eqn{j} in PSU \eqn{i} of stratum \eqn{h}

\eqn{\bullet}{}
\eqn{z_{hij}}{z_hij} denotes the observed value of the analysis variable \eqn{z} for household \eqn{j} in PSU \eqn{i} of stratum \eqn{h}
}
\examples{
Ys <- rchisq(10, 3)
w <- rep(2, 10)
PSU <- 1 : length(Ys)
H <- rep("Strata_1", 10)

# by default without using fh_zero (finite population correction)
variance_est(Y = Ys, H = H, PSU = PSU, w_final = w)


\dontrun{
 # without using fh_zero (finite population correction)
 variance_est(Y = Ys, H = H, PSU = PSU, w_final = w, fh_zero = FALSE)
 
 # with using fh_zero (finite population correction)
 variance_est(Y = Ys, H = H, PSU = PSU, w_final = w, fh_zero = TRUE)
 }

}
\references{
Morris H. Hansen, William N. Hurwitz, William G. Madow, (1953), Sample survey methods and theory Volume I Methods and applications, 257-258, Wiley. \cr
Guillaume Osier and Emilio Di Meglio. The linearisation approach implemented by Eurostat for the first wave of EU-SILC: what could be done from the second onwards? 2012 \cr
Eurostat Methodologies and Working papers, Standard error estimation for the EU-SILC indicators of poverty and social exclusion, 2013, URL \url{http://ec.europa.eu/eurostat/documents/3859598/5927001/KS-RA-13-029-EN.PDF}. \cr 
Yves G. Berger, Tim Goedeme, Guillame Osier (2013). Handbook on standard error estimation and other related sampling issues in EU-SILC, URL \url{https://ec.europa.eu/eurostat/cros/content/handbook-standard-error-estimation-and-other-related-sampling-issues-ver-29072013_en} \cr
Eurostat Methodologies and Working papers, Handbook on precision requirements and variance estimation for ESS household surveys, 2013, URL \url{http://ec.europa.eu/eurostat/documents/3859598/5927001/KS-RA-13-029-EN.PDF}. \cr
}
\seealso{
\code{\link{domain}},   \code{\link{lin.ratio}},    \code{\link{linarpr}},
         \code{\link{linarpt}},  \code{\link{lingini}},      \code{\link{lingini2}},
         \code{\link{lingpg}},   \code{\link{linpoormed}},   \code{\link{linqsr}},
         \code{\link{linrmpg}},  \code{\link{residual_est}}, \code{\link{vardom}},
         \code{\link{vardomh}}, \code{\link{varpoord}},     \code{\link{variance_othstr}}
}
\keyword{vardpoor}
