% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.fastq.specification.R
\name{prepare.fastq.specification}
\alias{prepare.fastq.specification}
\title{prepare.fastq.specification}
\usage{
prepare.fastq.specification(sample.details, sample.id.column = 1,
  fastq.columns = c(2, 3), patient.id.column = NA,
  tissue.column = NA)
}
\arguments{
\item{sample.details}{Data frame where each row represents a sample to be run. Must contain sample ID, path to tumour BAM, and path to normal BAM.}

\item{sample.id.column}{Index or string giving column of \code{sample.details} that contains the sample ID}

\item{fastq.columns}{Index or string giving column(s) of \code{sample.details} that contain path to FASTQ files}

\item{patient.id.column}{Index or string giving column of \code{sample.details} that contains the patient ID}

\item{tissue.column}{Index or string giving column of \code{sample.details} that contains information on tissue (tumour/ normal)}
}
\value{
Data frame with one row per sample to be run
}
\description{
Prepare FASTQ specification data frame to standardized format for downstream analyses.
}
\details{
This function prepares a data frame that can be used to run alignment.
 For paired-end reads, this data frame will contain three columns with names: sample.id, reads, mates
 For single-end reads, the data frame will contain two columns with names: sample.id, reads
}
