% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcPB.R
\name{vc.pb}
\alias{vc.pb}
\title{Varying-Coefficient Disparity Decomposition Analysis for a Longitudinal Data}
\usage{
vc.pb(
  formula,
  group,
  data,
  id,
  modifier = NULL,
  local_time = NULL,
  bandwidth_M = NULL,
  bandwidth_m = NULL,
  bandwidth_xM = NULL,
  bandwidth_xm = NULL,
  bandwidth_Z_M = NULL,
  bandwidth_Z_m = NULL,
  bandwidth_Z_xM = NULL,
  bandwidth_Z_xm = NULL,
  detail = FALSE,
  ...
)
}
\arguments{
\item{formula}{a formula for the model.}

\item{group}{a vector within the \code{data} which is used for separating majority and minority groups.}

\item{data}{a data frame and data has to be included with the form of \code{data.frame}.}

\item{id}{a vector within the \code{data} which is used for identifying the observations.}

\item{modifier}{(optional) a vector from the \code{data} which is an optional argument to add the varying term into the model. The default is \code{NULL}. If the class of the vector is given as
\code{integer} then, the continuous version of \code{vc.PB} is performed and if the class is \code{factor} or \code{character}, then the discrete version is proceeded. Three different sets of
inputs are needed for different versions.}

\item{local_time}{(optional) a vector used for the local points of time variable in the kernel regression.}

\item{bandwidth_M}{(optional) a bandwidth for the time variable used for estimating the time-varying coefficient of the majority group.}

\item{bandwidth_m}{(optional) a bandwidth for the time variable used for estimating the time-varying coefficient of the minority group.}

\item{bandwidth_xM}{(optional) a vector of \code{p} number of bandwidths for estimating the local expectations of the design matrix for the majority group.}

\item{bandwidth_xm}{(optional) a vector of \code{p} number of bandwidths for estimating the local expectations of the design matrix for the minority group.}

\item{bandwidth_Z_M}{(optional) a bandwidth for the varying variable used for estimating the time-varying coefficient of the majority group. Used only when the class of \code{modifier} is \code{integer}.}

\item{bandwidth_Z_m}{(optional) a bandwidth for the varying variable used for estimating the time-varying coefficient of the minority group. Used only when the class of \code{modifier} is \code{integer}.}

\item{bandwidth_Z_xM}{(optional) a vector of \code{p} number of bandwidths for estimating the local expectations of the design matrix related to varying variable for the majority group. Used only when the class of \code{modifier} is \code{integer}.}

\item{bandwidth_Z_xm}{(optional) a vector of \code{p} number of bandwidths for estimating the local expectations of the design matrix related to varying variable for the minority group. Used only when the class of \code{modifier} is \code{integer}.}

\item{detail}{a bool argument whether the detailed results are provided or not.}

\item{...}{used for controlling the others.}
}
\value{
\code{vc.pb} returns an object of class \code{"vc.pb"}, which is a list containing
following components:

\item{call}{a matched call.}
\item{overall_disparity}{overall disparity between major and minor groups.}
\item{explained_disparity}{explained disparity between major and minor groups, this component is given only when \code{varying} is null.}
\item{explained_disparity_by_X}{explained disparity from the variables without \code{modifier} variable given that the modifier variable is from the majority group, this component is given only when \code{varying} is not null.}
\item{explained_disparity_by_Z}{explained disparity from \code{modifier} variable, this component is given only when \code{varying} is not null.}
\item{unexplained_disparity}{unexplained disparity between major and minor groups.}
\item{times}{local time points used for kernel regression.}
\item{major}{a majority group label.}
\item{minor}{a minority group label.}
\item{modfier, varying.type}{the modifier variable and the type of the modifier variable, these components are given only when \code{varying} is not null.}
\item{bandwidths}{various corresponding bandwidths. Please see the details or the attached reference for more information.}
}
\description{
The \code{vc.pb} offers Peters-Belson(PB) type of nonparametric varying-coefficient regression method which measures the disparity between a majority group
and a minority group for the longitudinal data.
}
\examples{
set.seed(1)
n <- 100
x1 <- rnorm(n)
x2 <- rnorm(n)
time <- rep(1:5, 20) + runif(n)
y <- rnorm(n)
sub_id <- rep(1:25, 1, each = 4)
group <- rep(as.character(1:2), 25, each = 2)
z <- as.character(rbinom(n, 1, prob = 0.5))

data <- data.frame(y = y, x1 = x1, x2 = x2, z = z, group = group, time = time, sub_id = sub_id)

fit <- vc.pb(y ~ (x1|time) + x2, data = data, id = sub_id, group = group)
fit
}
\author{
Sang Kyu Lee
}
