% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_datazoom}
\alias{v_specs_datazoom}
\title{Add data zoom to a chart}
\usage{
v_specs_datazoom(
  vc,
  start = "{label:\%Y-\%m-\%d}",
  end = "{label:\%Y-\%m-\%d}",
  ...,
  brush = TRUE
)
}
\arguments{
\item{vc}{A chart created with \code{\link[=vchart]{vchart()}}.}

\item{start, end}{Formatter for the start/end label, e.g. : \code{"Start: \\{label:\%Y-\%m-\%d\\}"},
where the part between braces will be replaced by the date with the format specified.}

\item{...}{Additional parameters for dataZoom property,
see \href{https://www.visactor.io/vchart/option/commonChart#dataZoom}{online documentation}.}

\item{brush}{Logical, add the ability to brush the chart to zoom in.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Add data zoom to a chart
}
\examples{

library(vchartr)

data("economics", package = "ggplot2")
vchart(economics, aes(date, unemploy)) \%>\%
  v_line() \%>\%
  v_specs_datazoom()


co2_emissions \%>\%
  subset(country \%in\% c("China", "United States", "India")) \%>\%
  vchart() \%>\%
  v_line(aes(year, co2, color = country)) \%>\%
  v_specs_datazoom(start = "{label:.0f}", startValue = 1990, end = "{label:.0f}")
}
