% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.gen.log}
\alias{meta.ave.gen.log}
\title{Exponentiated confidence interval for an average of log-transformed
parameters}
\usage{
meta.ave.gen.log(alpha, est, se, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est}{vector of log-transformed parameter estimates}

\item{se}{vector of standard errors for log-transformed estimates}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated log effect size (from input)
\item SE - standard error of log effect size (from input)
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - exponentiated estimate
\item LL - lower limit of the exponentiated confidence interval
\item UL - upper limit of the exponentiated confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average of any type of log-transformed parameter (e.g., log mean ratio,
log proportion ratio, log odds ratio) from two or more studies.
}
\examples{

est <- c(.165, .193, .218)
se <- c(.0684, .0921, .0882)
meta.ave.gen.log(.05, est, se, bystudy = TRUE)

# Should return:
#         Estimate         SE         LL        UL exp(Estimate)
# Average    0.192 0.04823578 0.09745962 0.2865404      1.211671
# Study 1    0.165 0.06840000 0.03093846 0.2990615      1.179393
# Study 2    0.193 0.09210000 0.01248732 0.3735127      1.212883
# Study 3    0.218 0.08820000 0.04513118 0.3908688      1.243587
#          exp(LL)  exp(UL)
# Average 1.102367 1.331812
# Study 1 1.031422 1.348593
# Study 2 1.012566 1.452829
# Study 3 1.046165 1.478265


}
