% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cassettes.R
\name{cassettes}
\alias{cassettes}
\alias{current_cassette}
\alias{current_cassette_recording}
\alias{current_cassette_replaying}
\alias{cassette_path}
\title{List cassettes, get current cassette, etc.}
\usage{
cassettes()

current_cassette()

current_cassette_recording()

current_cassette_replaying()

cassette_path()
}
\description{
List cassettes, get current cassette, etc.
}
\details{
\itemize{
\item \code{cassettes()}: returns all active cassettes in the current
session.
\item \code{current_cassette()}: returns \code{NULL} when no cassettes are in use;
returns the current cassette (a \code{Cassette} object) when one is in use
\item \code{currrent_cassette_recording()} and \code{current_cassette_replaying()}:
tell you if the current cassette is recording and/or replaying. They
both return \code{FALSE} if there is no cassette in use.
\item \code{cassette_path()}: returns the current directory path where cassettes
will be stored
}
}
\examples{
vcr_configure(dir = tempdir())

# list all cassettes
cassettes()

# list the currently active cassette
insert_cassette("stuffthings")
current_cassette()
cassettes()

eject_cassette()
cassettes()


# list the path to cassettes
cassette_path()
vcr_configure(dir = file.path(tempdir(), "foo"))
cassette_path()

vcr_configure_reset()
}
