% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which.of.one.set.is.not.in.another.R
\name{which.of.one.set.is.not.in.another}
\alias{which.of.one.set.is.not.in.another}
\title{Which of One Set is not in Another}
\usage{
which.of.one.set.is.not.in.another(set_1, set_2, suppress_messages = FALSE)
}
\arguments{
\item{set_1}{A vector to be subtracted from.}

\item{set_2}{A vector to subtract from \code{set_1}.}

\item{suppress_messages}{A logical (TRUE/FALSE) indicator whether to suppress messages.}
}
\value{
A vector of the values of \code{set_1} that are not present in \code{set_2}. Put differently, a vector resulting from subtracting \code{set_2} from \code{set_1}.
}
\description{
This function is a wrapper for \code{\link{setdiff}}. It makes it easier to remember which vector is being subtracted from the other, by displaying an explicit message.
}
\examples{
veccompare::which.of.one.set.is.not.in.another(
    veccompare::example.vectors.list$vector_a,
    veccompare::example.vectors.list$vector_b
)

veccompare::which.of.one.set.is.not.in.another(
    veccompare::example.vectors.list$vector_b,
    veccompare::example.vectors.list$vector_a
)

}
