% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infix.R
\name{Infix Bitwise Operators}
\alias{Infix Bitwise Operators}
\alias{`\%|\%`}
\alias{`\%&\%`}
\alias{`\%^\%`}
\alias{`\%<<\%`}
\alias{`\%>>\%`}
\alias{\%|\%}
\alias{\%&\%}
\alias{\%^\%}
\alias{\%<<\%}
\alias{\%>>\%}
\title{Infix operators for bitwise operations.}
\usage{
a \%|\% b

a \%&\% b

a \%^\% b

a \%<<\% n

a \%>>\% n
}
\arguments{
\item{a, b}{Integer vectors. Numerics are coerced to integers.}

\item{n}{Non-negative integer vector of values up to 31.}
}
\value{
An integer vector of length of the longer of the arguments, or zero if one of the arguments is zero-length. NA input makes NA output.

\verb{\%|\%}: A vector of pairwise ORed values.

\verb{\%&\%}: A vector of pairwise ANDed values.

\verb{\%^\%}: A vector of pairwise XORed values.

\verb{\%<<\%}: A vector of the values on the LHS pairwise left-shifted by the RHS value.

\verb{\%>>\%}: A vector of the values on the LHS pairwise right-shifted by the RHS value.
}
\description{
Basic infix wrapper around the base::bitw_OP_ operations.
}
\examples{
1 \%|\% 2
1 \%&\% 2
1 \%^\% 2
1 \%<<\% 2
8 \%>>\% 2
}
