% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vectorwavelet.R
\name{plot.vectorwavelet}
\alias{plot.vectorwavelet}
\title{Plot \code{vectorwavelet} objects}
\usage{
\method{plot}{vectorwavelet}(
  x,
  ncol = 1024,
  fill.cols = NULL,
  xlab = "Time",
  ylab = "Period",
  tol = 1,
  plot.cb = FALSE,
  plot.coi = TRUE,
  lwd.coi = 1,
  col.coi = "white",
  lty.coi = 1,
  alpha.coi = 0.5,
  plot.sig = TRUE,
  lwd.sig = 4,
  col.sig = "black",
  lty.sig = 1,
  bw = FALSE,
  legend.loc = NULL,
  legend.horiz = FALSE,
  arrow.len = min(par()$pin[2]/30, par()$pin[1]/40),
  arrow.lwd = arrow.len * 0.3,
  arrow.cutoff = 0.7,
  arrow.col = "black",
  xlim = NULL,
  ylim = NULL,
  zlim = c(0, 1),
  xaxt = "s",
  yaxt = "s",
  form = "\%Y",
  ...
)
}
\arguments{
\item{x}{\code{vectorwavelet} object generated by \code{mwc}, \code{qmec}, or
\code{vwc}.}

\item{ncol}{number of colors to use. Default is 1024.}

\item{fill.cols}{Vector of fill colors to be used. Users can specify color
vectors using \code{colorRampPalette} or \code{brewer.pal} from package
\code{RColorBrewer}. Default is \code{NULL} and will generate MATLAB's jet
color palette.}

\item{xlab}{xlabel of the figure. Default is "Time"}

\item{ylab}{ylabel of the figure. Default is "Period"}

\item{tol}{tolerance level for significance contours. Sigificance contours
will be drawn around all regions of the spectrum where
\code{spectrum/percentile >= tol}. Default is \code{1}. If strict
\code{i^{th}} percentile regions are desired, then
\code{tol} must be set to \code{1}.}

\item{plot.cb}{plot color bar if TRUE. Default is FALSE.}

\item{plot.coi}{plot cone of influence (COI) as a semi-transparent polygon if
TRUE. Default is TRUE. Areas that fall within the polygon can be affected
by edge effects.}

\item{lwd.coi}{Line width of COI. Default is 1.}

\item{col.coi}{Color of COI. Default is \code{white}.}

\item{lty.coi}{Line type of COI. Default is 1 for solide lines.}

\item{alpha.coi}{Transparency of COI. Range is 0 (full transparency) to 1 (no
transparency). Default is 0.5.}

\item{plot.sig}{plot contours for significance if TRUE. Default is TRUE.}

\item{lwd.sig}{Line width of significance contours. Default is 4.}

\item{col.sig}{Color of significance contours. Default is \code{black}.}

\item{lty.sig}{Line type of significance contours. Default is 1.}

\item{bw}{plot in black and white if TRUE. Default is FALSE.}

\item{legend.loc}{legend location coordinates as defined by
\code{image.plot}. Default is \code{NULL}.}

\item{legend.horiz}{plot a horizontal legend if TRUE. Default is FALSE.}

\item{arrow.len}{size of the arrows. Default is based on plotting region
(min(par()$pin[2]/30,par()$pin[1]/40).}

\item{arrow.lwd}{width/thickness of arrows. Default is arrow.len*0.3.}

\item{arrow.cutoff}{cutoff value for plotting phase arrows. Phase arrows will be
be plotted in regions where the significance of the zvalues exceeds \code{arrow.cutoff}.
If the object being plotted does not have a significance field, regions
whose zvalues exceed the \code{arrow.cutoff} quantile will be plotted. Default is 0.7.}

\item{arrow.col}{Color of arrows. Default is \code{black}.}

\item{xlim}{the x limits. The default is \code{NULL}.}

\item{ylim}{the y limits. The default is \code{NULL}.}

\item{zlim}{the z limits. The default is \code{NULL}.}

\item{xaxt}{Add x-axis? The default is \code{s}; use \code{n} for none.}

\item{yaxt}{Add y-axis? The default is \code{s}; use \code{n} for none.}

\item{form}{format to use to display dates on the x-axis. Default is '\%Y'
for 4-digit year. See \code{?Date} for other valid formats.}

\item{\dots}{other parameters.}
}
\value{
No return value, shows the objects plot.
}
\description{
Plot \code{vectorwavelet} objects which are multiple wavelet coherence,
  quadruple wavelet coherence and n-dimensional vector wavelet coherence.
}
\author{
Tunc Oygur (info@tuncoygur.com.tr)

Code based on biwavelet package written by Tarik C. Gouhier.
}
