% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vwc.R
\name{vwc}
\alias{vwc}
\title{Compute n-dimensional vector wavelet coherence}
\usage{
vwc(
  y,
  x,
  pad = TRUE,
  dj = 1/12,
  s0 = 2 * dt,
  J1 = NULL,
  max.scale = NULL,
  mother = "morlet",
  param = -1,
  lag1 = NULL,
  sig.level = 0.95,
  sig.test = 0,
  nrands = 300,
  quiet = FALSE
)
}
\arguments{
\item{y}{time series y in matrix format (\code{m} rows x 2 columns). The
first column should contain the time steps and the second column should
contain the values.}

\item{x}{multivariate time series x in matrix format (\code{m} rows x n columns).
The first column should contain the time steps and the other columns should
contain the values.}

\item{pad}{pad the values will with zeros to increase the speed of the
transform. Default is TRUE.}

\item{dj}{spacing between successive scales. Default is 1/12.}

\item{s0}{smallest scale of the wavelet. Default is \code{2*dt}.}

\item{J1}{number of scales - 1.}

\item{max.scale}{maximum scale. Computed automatically if left unspecified.}

\item{mother}{type of mother wavelet function to use. Can be set to
\code{morlet}, \code{dog}, or \code{paul}. Default is \code{morlet}.
Significance testing is only available for \code{morlet} wavelet.}

\item{param}{nondimensional parameter specific to the wavelet function.}

\item{lag1}{vector containing the AR(1) coefficient of each time series.}

\item{sig.level}{significance level. Default is \code{0.95}.}

\item{sig.test}{type of significance test. If set to 0, use a regular
\eqn{\chi^2} test. If set to 1, then perform a time-average test. If set to
2, then do a scale-average test.}

\item{nrands}{number of Monte Carlo randomizations. Default is 300.}

\item{quiet}{Do not display progress bar. Default is \code{FALSE}}
}
\value{
Return a \code{vectorwavelet} object containing:
\item{coi}{matrix containg cone of influence}
\item{rsq}{matrix of wavelet coherence}
\item{phase}{matrix of phases}
\item{period}{vector of periods}
\item{scale}{vector of scales}
\item{dt}{length of a time step}
\item{t}{vector of times}
\item{xaxis}{vector of values used to plot xaxis}
\item{s0}{smallest scale of the wavelet }
\item{dj}{spacing between successive scales}
\item{mother}{mother wavelet used}
\item{type}{type of \code{vectorwavelet} object created (\code{vwc})}
\item{signif}{matrix containg \code{sig.level} percentiles of wavelet coherence
              based on the Monte Carlo AR(1) time series}
}
\description{
Compute n-dimensional vector wavelet coherence
}
\examples{
old.par <- par(no.readonly=TRUE)

t <- (-100:100)

y <- sin(t*2*pi)+sin(t*2*pi/4)+sin(t*2*pi/8)+sin(t*2*pi/16)+sin(t*2*pi/32)+sin(t*2*pi/64)
x1 <- sin(t*2*pi/8)
x2 <- sin(t*2*pi/16)
x3 <- sin(t*2*pi/32)
x4 <- sin(t*2*pi/64)

y <- cbind(t,y)
x <- cbind(t,x1,x2,x3,x4)

## n-dimensional multiple wavelet coherence
result <- vwc(y, x, nrands = 10)
\donttest{
result <- vwc(y, x)
}

## Plot wavelet coherence and make room to the right for the color bar
## Note: plot function can be used instead of plot.vectorwavelet
par(oma = c(0, 0, 0, 1), mar = c(5, 4, 4, 5) + 0.1,  pin = c(3,3))
plot.vectorwavelet(result, plot.cb = TRUE, main = "Plot n-dimensional vwc (n=5)")

par(old.par)

}
\references{
T. Oygur, G. Unal.. Vector wavelet coherence for multiple time series.
\emph{Int. J. Dynam. Control (2020).}
}
\author{
Tunc Oygur (info@tuncoygur.com.tr)
}
\keyword{coherence}
\keyword{continuous}
\keyword{n-dimensional}
\keyword{transform}
\keyword{wavelet}
