% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwm.R
\name{cwm}
\alias{cwm}
\title{Indicate site conditions with community weighted mean values of traits or with mode of gradient classes (sum of species amplitudes).}
\usage{
cwm(
  veg,
  refl,
  trait.db = "ecodbase.dbf",
  ivname,
  keyname = "LETTERCODE",
  method = c("mean", "mode"),
  weight,
  db,
  ...
)
}
\arguments{
\item{veg}{Vegetation matrix with plots in rows and species in columns}

\item{refl}{Name of Turboveg taxonomic reference list}

\item{trait.db}{data frame with species trait values}

\item{ivname}{Name of the trait in trait.db to be used}

\item{keyname}{Name of the column in trait dataframe to join with colnames of veg table}

\item{method}{mean (weighted value of single traits, or mode (maximum) of trait classes)}

\item{weight}{additional weight, e.g niche breath of species}

\item{db}{name of Turboveg database}

\item{\dots}{additional arguments}
}
\value{
Vector with the ecological classification of sites. Either mean trait values or mode of gradient classes.
}
\description{
Calculates community weighted mean trait values, like mean Ellenberg indicator values.
  Alternatively (method = 'mode') environmental conditions can be calculated according to the concept of sums of amplitudes of species along ecological gradients.
}
\details{
Trait values of 0 will be handled as NA values because Turboveg dBase can not handle NA values properly.
}
\examples{
  \dontrun{
    db <- 'elbaue'
    veg <- tv.veg(db, cover.transform='sqrt', check.critical = FALSE)
    site <- tv.site(db, verbose = FALSE)

    #' Mean indicator values of Ellenberg F values
    mEIV_F <- cwm(veg, ivname = 'OEK_F', method = 'mean')
    plot(site$MGL, mEIV_F, xlab = 'Mean groundwater level')
  }

}
\author{
Florian Jansen \email{florian.jansen@uni-rostock.de}
}
