% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/veg_starts.R
\name{method_ETCCDI}
\alias{method_ETCCDI}
\title{Vegetation Start and End Method "ETCCDI"}
\description{
The \code{ETCCDI} or \code{StdMeteo} method was defined by  Expert Team on Climate Change Detection and Indices and is often known as Growing season Length (GSL) and widely used in climate change studies.
}
\section{Calculation}{

\subsection{Implementation of start}{

first span of at least 6 consecutive days with daily mean temperature TG > 5°C

\if{html}{\out{<div class="sourceCode">}}\preformatted{# mark days warmer than 5°C
df$period <- ifelse(df$Tavg > Tmin, 1, 0)

# find first six day span per year
start <- tapply(df$period, df$year, FUN=function(x)\{
  sixer <- as.numeric(stats::filter(x, rep(1, 6), sides=1))
  doy <- which(!is.na(sixer) & sixer == 6)
  ifelse(length(doy) == 0, NA, min(doy))
\})
}\if{html}{\out{</div>}}
}

\subsection{Implementation of end}{

first span after July 1st of 6 consecutive days with TG < 5°C.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# 1. July is DOY 182 and DOY 183 in leap years
years <- unique(df$year)
leap_year <- ifelse((years\%\%4==0 & years\%\%100!=0) | years\%\%400==0, TRUE, FALSE)
jul1 <- ifelse(leap_year, 183L, 182L)

# mark days colder than 5°C
df$period <- ifelse(df$Tavg < Tmin, 1, 0)

# find first six day span per year
end <- ifelse(leap_year, 366L, 365L)
for(i in seq_along(years))\{
  temp <- df[df$year == years[i] & df$DOY > jul1[i], ]
  temp$six <-  as.numeric(stats::filter(temp$period, rep(1, 6), sides=1))
  possible.end <- temp[!is.na(temp$six) & temp$six == 6, "DOY"]
  if(length(possible.end) > 0)
    end[i] <- min(possible.end)
\}
}\if{html}{\out{</div>}}
}
}

\references{
Definition recommended by the CCl/CLIVAR/JCOMM Expert Team on Climate Change Detection and Indices (ETCCDI) http://etccdi.pacificclimate.org/list_27_indices.shtml http://www.climdex.org/indices.html

European Climate Assessment (ECA) http://eca.knmi.nl/indicesextremes/indicesdictionary.php

ETCCDI (2009) Climate Change Indices: Definitions of the 27 core indices. http://etccdi.pacificclimate.org/list_27_indices.shtml
Frich, P., Alexander, L., Della-Marta, P., Gleason, B., Haylock, M., Klein Tank, A. and Peterson, T. (2002) Observed coherent changes in climatic extremes during the second half of the twentieth century. Climate Research, 19, 193–212. https://doi.org/10.3354/cr019193.
http://www.climateknowledge.org/heat_waves/Doc2004_Frich_Extremes_Index_ClimResearch_2002.pdf

Zhang, X., Alexander, L., Hegerl, G. C., Jones, P., Tank, A. K., Peterson, T. C., Trewin, B. and Zwiers, F. W. (2011) Indices for monitoring changes in extremes based on daily temperature and precipitation data. Wiley Interdisciplinary Reviews: Climate Change, 2(6), 851–870. https://doi.org/10.1002/wcc.147.
}
\keyword{internal}
