% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additiveBeta.R
\name{taxonAlpha}
\alias{taxonAlpha}
\alias{taxonAlpha,meanAlpha,taxonBeta,sampleBeta,totalGamma}
\alias{meanAlpha}
\alias{taxonBeta}
\alias{sampleBeta}
\alias{totalBeta}
\alias{totalGamma}
\title{Additive Diversity Partitioning functions}
\usage{
taxonAlpha(CommunityMatrix)

meanAlpha(CommunityMatrix)

taxonBeta(CommunityMatrix)

sampleBeta(CommunityMatrix)

totalBeta(CommunityMatrix)

totalGamma(CommunityMatrix)
}
\arguments{
\item{CommunityMatrix}{a matrix}
}
\value{
A vector of the alpha, beta, or gamma richness of a taxon, sample, or entire community matrix.
}
\description{
Functions for calculating alpha, beta, and gamma richness of a community matrix under the Additive Diversity partitioning paradigm of R. Lande.
}
\details{
Takes a community matrix (see \code{presenceMatrix} or \code{abundanceMatrix}) and returns the either the alpha, beta, or gamma richness of a community matrix.

These functions were originally presented in Holland, SM (2010) "Additive diversity partitioning in palaeobiology: revisiting Sepkoski’s question" \emph{Paleontology} 53:1237-1254.

\itemize{
\item{\code{taxonAlpha(CommunityMatrix)}} {Calculates the contribution to alpha diversity of each taxon.}
\item{\code{meanAlpha(CommunityMatrix)}} {Calculates the average alpha diversity of all samples.}

\item{\code{taxonBeta(CommunityMatrix)}} {Calculates the contribution to beta diversity of each taxon.}
\item{\code{sampleBeta(CommunityMatrix)}} {Calculates the contribution to beta diversity of each sample.}
\item{\code{totalBeta(CommunityMatrix)}} {Calculates the total beta diversity.}

\item{\code{totalGamma(CommunityMatrix)}} {Calculates the richness of all samples in the community matrix.}
 }
}
\examples{
# Download a test dataset of pleistocene bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Pleistocene",StopInterval="Pleistocene")

# Create a community matrix with tectonic plates as "samples"
# CommunityMatrix<-abundanceMatrix(DataPBDB,"geoplate")

# Calculate the average richness of all samples in a community.
# meanAlpha(CommunityMatrix)

# The beta diversity of all samples in a community.
# totalBeta(CommunityMatrix)

# This is, by definition, equivalent to the gamma diversity - mean alpha diversity.
# totalBeta(CommunityMatrix)==(totalGamma(CommunityMatrix)-meanAlpha(CommunityMatrix))

}
\author{
Andrew A. Zaffos
}
