% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mse.R
\name{estimates_exist}
\alias{estimates_exist}
\title{Check whether stratum estimates already exist in pre-calculated files.}
\usage{
estimates_exist(stratum_data_prepped, estimates_dir)
}
\arguments{
\item{stratum_data_prepped}{A data frame including all records in a stratum of
interest. The data frame should only include the source columns prefixed with
\code{in_} and all columns should only contain 1's and 0's.}

\item{estimates_dir}{Directory containing pre-calculated estimates, if you
would like to use pre-calculated results.}
}
\value{
A list with two entries, \code{estimates_exist} and \code{estimates_path}.
\code{estimates_exist} is a logical value indicating whether calculations for the
stratum of interest are available in the directory containing the pre-calculated
estimates. If \code{estimates_exist} is \code{TRUE}, \code{estimates_path} will contain the
full file path to the JSON file containing the estimates, otherwise it will
be \code{NA}.
}
\description{
Check whether stratum estimates already exist in pre-calculated files.
}
\examples{
\donttest{
in_A <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.45, 0.65))
in_B <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.5, 0.5))
in_C <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.75, 0.25))
in_D <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(1, 0))

my_stratum <- tibble::tibble(in_A, in_B, in_C, in_D) \%>\%
    dplyr::mutate(rs = rowSums(.)) \%>\%
    dplyr::filter(rs >= 1) \%>\%
    dplyr::select(-rs)

estimates_exist(stratum_data_prepped = my_stratum, estimates_dir = "path_to_estimates")
}
}
